﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;
using System.Globalization;

namespace VIRP_WEB.Controls.Custom.BPR
{
    public partial class controls_UserControlAsOfDate : System.Web.UI.UserControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                CompareValidatorTextBoxAsOfDate.ValueToCompare = DateTime.Now.ToShortDateString();
                TextBoxAsOfDate.Text = DateTime.Now.ToShortDateString();
            }
        }

        public string AsOfDateValue { get; set; }

        /// <summary>
        /// Returns true if a date of 'MM/dd/yyyy' format can successfully be parsed from the As Of Date textbox or is null/empty
        /// </summary>
        public bool ValidateCustomValidator()
        {
            if (String.IsNullOrEmpty(this.AsOfDateValue))
                return true;

            DateTime dateTime;
            return DateTime.TryParseExact(this.AsOfDateValue, "MM/dd/yyyy", CultureInfo.InvariantCulture, DateTimeStyles.None, out dateTime);
        }
    }
}